<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CartItem extends Model 
{

    protected $table = 'cart_lines';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('qty', 'price', 'amount', 'discount', 'total_amount', 'grand_total', 'updated_by');

    public function product()
    {
        return $this->belongsTo('Product', 'katalog_id', 'id');
    }

}